/*
	    Script che converte da TYININT a INT il campo indicatore natura nella tabella dei dati fattura
*/

DECLARE @DNAME AS VARCHAR(128)
DECLARE @SQL AS NVARCHAR(MAX)

IF NOT EXISTS(SELECT TOP 1 1 FROM SYS.COLUMNS AS C INNER JOIN SYS.TYPES AS T ON T.SYSTEM_TYPE_ID = C.SYSTEM_TYPE_ID
              WHERE  C.OBJECT_ID = OBJECT_ID(N'CG3R_DATIFATTURE') AND C.NAME = N'CG3R_INDNATURA' AND T.NAME = N'INT')

	SET @DNAME = (SELECT TOP 1 D.NAME FROM SYS.DEFAULT_CONSTRAINTS AS D INNER JOIN SYS.TABLES  AS T ON T.OBJECT_ID = D.PARENT_OBJECT_ID 
                                                                    INNER JOIN SYS.COLUMNS AS C ON T.OBJECT_ID = C.OBJECT_ID AND C.COLUMN_ID = D.PARENT_COLUMN_ID 
                  WHERE T.NAME = 'CG3R_DATIFATTURE' AND C.NAME = 'CG3R_INDNATURA')

	IF ISNULL(@DNAME, '') <> ''
		BEGIN
			SET @SQL = 'ALTER TABLE dbo.CG3R_DATIFATTURE DROP CONSTRAINT ' +  @DNAME
			EXEC(@SQL)

			ALTER TABLE CG3R_DATIFATTURE
				ALTER COLUMN CG3R_INDNATURA INT NOT NULL

			ALTER TABLE CG3R_DATIFATTURE
				ADD CONSTRAINT DF__CG3R_DATI__CG3R_INDNATURA DEFAULT 0 FOR CG3R_INDNATURA
			
			PRINT 'Tabella CG3R_DATIFATTURE: campo CG3R_INDNATURA convertito a INT'
		END

 ELSE
	BEGIN
		PRINT 'Tabella CG3R_DATIFATTURE: campo CG3R_INDNATURA di tipo INT, conversione non effettuata'
	END		
GO
